#include <iostream>
#include <string>
#include <vector>
#include <iomanip>
#include <set>
#include <map>
#include <algorithm>
#include <cmath>
#include <array>
using namespace std;
const double eps = 0.00000001;
struct point {
	double x, y;
};
double cross(point p1, point p2) {
	return p1.x * p2.y - p2.x * p1.y;
}
double scalar(point p1, point p2) {
	return p1.x * p2.x + p1.y * p2.y;
}
point kramer(double a1, double b1, double c1, double a2, double b2, double c2) {
	c1 = -c1;
	c2 = -c2;
	double d = a1 * b2 - b1 * a2;
	double dx = c1 * b2 - b1 * c2;
	double dy = a1 * c2 - c1 * a2;
	return { dx / d, dy / d };
}
point scl(point p, double x) {
	return { p.x * x, p.y * x };
}
double len(point p) {
	return sqrt(p.x * p.x + p.y * p.y);
}
int main() {
	cout << setprecision(20) << fixed;
	long long t;
	cin >> t;
	while (t--) {
		long long n;
		cin >> n;
		vector<pair<point, point>> v(n);
		for (long long i = 0; i < n; i++) {
			cin >> v[i].first.x >> v[i].first.y >> v[i].second.x >> v[i].second.y;
		}
		long long p = 0;
		long long r = 0;
		for (long long i = 0; i < n; i++) {
			long long cnt = -1;
			for (long long j = 0; j < n; j++) {
				if (i == j) {
					continue;
				}
				point p1 = { v[i].second.x - v[i].first.x, v[i].second.y - v[i].first.y };
				point p2 = { v[j].second.x - v[j].first.x, v[j].second.y - v[j].first.y };
				double a = -p1.y, b = p1.x, c = -(a * v[i].first.x) - (b * v[i].first.y);
				double a1 = -p2.y, b1 = p2.x, c1 = -(a1 * v[j].first.x) - (b1 * v[j].first.y);
				point p3 = kramer(a, b, c, a1, b1, c1);
				point p4 = { p3.x - v[i].first.x, p3.y - v[i].first.y };
				point p5 = { p3.x - v[j].first.x, p3.y - v[j].first.y };
				if (len(p1) < len(p4) || len(p2) < len(p5)) {
					continue;
				}
				p1 = scl(p1, len(p4) / len(p1));
				p2 = scl(p2, len(p5) / len(p2));
				if (abs(p1.x - p4.x) <= eps && abs(p1.y - p4.y) <= eps && abs(p2.x - p5.x) <= eps && abs(p2.y - p5.y) <= eps) {
					if (j > i) {
						p++;
					}
					cnt++;
				}
			}
			if (cnt == -1) {
				continue;
			}
			r += cnt;
		}
		cout << r - p + 1 + 1 << endl;
	}
}
